<?php
header('Content-Type: application/json');
include 'db.php';

// Get customer ID from request
$customer_id = $_GET['id'] ?? null;

if (!$customer_id) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Customer ID is required'
    ]);
    exit;
}

// Sanitize input
$customer_id = mysqli_real_escape_string($conn, $customer_id);

// Prepare response array
$response = [
    'status' => 'error',
    'message' => 'Customer not found',
    'data' => null
];

try {
    // Query to get customer data
    $query = "SELECT 
                displayname, email, phoneno, address, address2, 
                city, state, pincode, name1, sphoneno,
                sname, saddress, scity, spincode, sstate
              FROM customer 
              WHERE id = '$customer_id' LIMIT 1";
    
    $result = mysqli_query($conn, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $customer_data = mysqli_fetch_assoc($result);
        
        $response = [
            'status' => 'success',
            'message' => 'Customer data retrieved successfully',
            'data' => [
                'displayname' => $customer_data['displayname'] ?? '',
                'email' => $customer_data['email'] ?? '',
                'phone' => $customer_data['phoneno'] ?? '',
                'address' => $customer_data['address'] ?? '',
                'address2' => $customer_data['address2'] ?? '',
                'city' => $customer_data['city'] ?? '',
                'state' => $customer_data['state'] ?? '',
                'pincode' => $customer_data['pincode'] ?? '',
                'name1' => $customer_data['name1'] ?? '',
                'sphoneno' => $customer_data['sphoneno'] ?? '',
                'sname' => $customer_data['sname'] ?? '',
                'saddress' => $customer_data['saddress'] ?? '',
                'scity' => $customer_data['scity'] ?? '',
                'spincode' => $customer_data['spincode'] ?? '',
                'sstate' => $customer_data['sstate'] ?? ''
            ]
        ];
    }
} catch (Exception $e) {
    $response['message'] = 'Database error: ' . $e->getMessage();
}

// Close connection
mysqli_close($conn);

// Return JSON response
echo json_encode($response);
?>